<?php
add_action('plugins_loaded', 'woocommerce_smart_cart_gateway_init', 0);
add_filter( 'woocommerce_available_payment_gateways', 'webexpert_smart_cart_disable' );

function webexpert_smart_cart_disable( $available_gateways ) {
	if (is_admin()) return $available_gateways;

    if ( isset( $available_gateways['skroutz_smart_cart'] ) && !current_user_can( 'manage_options' ) ) {
        unset( $available_gateways['skroutz_smart_cart'] );
    }
    return $available_gateways;
}

function woocommerce_smart_cart_gateway_init()
{
    if (!class_exists('WC_Payment_Gateway'))
        return;

    class WC_Smart_Cart_Gateway extends WC_Payment_Gateway {

        public function __construct() {
            $this->id                 = 'skroutz_smart_cart';
            $this->icon               = apply_filters( 'webexpert_skroutz_smart_cart', '' );
            $this->method_title       = __( 'Skroutz Smart Cart', 'webexpert-woocommerce-skroutz-smart-cart' );
            $this->method_description = __( 'Skroutz Smart Cart payment method can be used to group orders made from Skroutz Smart Cart', 'webexpert-woocommerce-skroutz-smart-cart' );
            $this->has_fields         = false;
            $this->init_form_fields();
            $this->init_settings();
            $this->title = $this->get_option('title');
            $this->description = $this->get_option('description');
            add_action('woocommerce_update_options_payment_gateways_' . $this->id, array($this, 'process_admin_options'));
        }

        public function init_form_fields() {
            $shipping_methods = array();

            $this->form_fields = array(
                'enabled' => array(
                    'title'       => __( 'Enable/Disable', 'webexpert-woocommerce-skroutz-smart-cart' ),
                    'label'       => __( 'Enable Skroutz Smart Cart', 'webexpert-woocommerce-skroutz-smart-cart' ),
                    'type'        => 'checkbox',
                    'description' => __('Enable or disable the gateway.', 'webexpert-woocommerce-skroutz-smart-cart'),
                    'default'     => 'yes',
                ),
                'title' => array(
                    'title'       => __( 'Title', 'webexpert-woocommerce-skroutz-smart-cart' ),
                    'type'        => 'text',
                    'description' => __( 'Payment method description that the customer will see on your checkout.', 'webexpert-woocommerce-skroutz-smart-cart' ),
                    'default'     => __( 'Skroutz Smart Cart', 'webexpert-woocommerce-skroutz-smart-cart' ),
                    'desc_tip'    => true,
                ),
                'description' => array(
                    'title'       => __( 'Description', 'webexpert-woocommerce-skroutz-smart-cart' ),
                    'type'        => 'textarea',
                    'description' => __( 'Payment method description that the customer will see on your website.', 'webexpert-woocommerce-skroutz-smart-cart' ),
                    'default'     => __( 'Skroutz Smart Cart.', 'webexpert-woocommerce-skroutz-smart-cart' ),
                    'desc_tip'    => true,
                ),
            );
        }
    }
}
