<?php

/**
 * Fired during plugin activation
 *
 * @link       https://www.webexpert.gr/
 * @since      1.0.0
 *
 * @package    Webexpert_Woocommerce_Skroutz_Smart_Cart
 * @subpackage Webexpert_Woocommerce_Skroutz_Smart_Cart/includes
 */

/**
 * Fired during plugin activation.
 *
 * This class defines all code necessary to run during the plugin's activation.
 *
 * @since      1.0.0
 * @package    Webexpert_Woocommerce_Skroutz_Smart_Cart
 * @subpackage Webexpert_Woocommerce_Skroutz_Smart_Cart/includes
 * @author     Web Expert <info@webexpert.gr>
 */
class Webexpert_Woocommerce_Skroutz_Smart_Cart_Activator {

	/**
	 * Short Description. (use period)
	 *
	 * Long Description.
	 *
	 * @since    1.0.0
	 */
	public static function activate() {
		$license=get_option('webexpert_skroutz_smart_cart_valid_license',false);
		if ($license===false) {
			$url='https://www.webexpert.gr/plugins/updates/?action=get_metadata&slug=webexpert-woocommerce-skroutz-smart-cart&license_key='.get_option('webexpert_skroutz_smart_cart_license_key').'&domain='.get_bloginfo('url');
			$request = wp_remote_get($url);
			$response = wp_remote_retrieve_body( $request );
			$s = json_decode($response);
			if (isset($s->download_url)) {
				update_option('webexpert_skroutz_smart_cart_valid_license',true);
			}else {
				delete_option('webexpert_skroutz_smart_cart_valid_license');
			}
		}
	}

}
